// Content script - massimo parallelismo
(function() {
    chrome.storage.sync.get({
        serverUrl: 'http://72.61.85.207:3847',
        etvEnabled: true,
        etvLocation: '',
        etvLanguage: '',
        gmbEnabled: true,
        gmbGeo: 'it'
    }, function(CONFIG) {
        runCalculation(CONFIG);
    });

    function runCalculation(CONFIG) {
        console.log('[EDC] Avvio con config:', CONFIG);

        if (window.edcRunning) {
            alert('Calcolo già in corso!');
            return;
        }
        window.edcRunning = true;

        // CSS
        if (!document.getElementById('edc-style')) {
            var style = document.createElement('style');
            style.id = 'edc-style';
            style.textContent = '.edc-hdr{background:#2c3e50!important;color:#fff!important;text-align:center!important;padding:5px 10px!important;font-weight:bold!important}.edc-cell{text-align:center!important;font-family:monospace!important;font-size:12px!important}.edc-hi{color:#27ae60;font-weight:bold}.edc-md{color:#f39c12;font-weight:bold}.edc-lo{color:#999}.edc-yes{background:#27ae60;color:#fff;padding:2px 6px;border-radius:3px;font-weight:bold;font-size:11px}.edc-no{background:#e74c3c;color:#fff;padding:2px 6px;border-radius:3px;font-weight:bold;font-size:11px}.edc-load{color:#3498db}.edc-bar{position:fixed;top:10px;left:50%;transform:translateX(-50%);background:#667eea;color:#fff;padding:12px 25px;border-radius:8px;z-index:99999;font-family:Arial,sans-serif;font-size:14px;box-shadow:0 4px 15px rgba(0,0,0,.3)}';
            document.head.appendChild(style);
        }

        // Progress bar
        var bar = document.getElementById('edc-bar');
        if (bar) bar.remove();
        bar = document.createElement('div');
        bar.id = 'edc-bar';
        bar.className = 'edc-bar';
        bar.textContent = 'Cerco domini...';
        document.body.appendChild(bar);

        // Trova tabella
        var table = document.querySelector('table.base1');
        if (!table) {
            bar.textContent = 'ERRORE: Tabella non trovata!';
            window.edcRunning = false;
            setTimeout(function() { bar.remove(); }, 3000);
            return;
        }

        // Trova domini
        var domains = [];
        var domainMap = {}; // Per lookup veloce
        var rows = table.querySelectorAll('tbody tr');
        for (var i = 0; i < rows.length; i++) {
            var row = rows[i];
            var cell = row.querySelector('td.field_domain');
            if (!cell) continue;
            var link = cell.querySelector('a');
            if (!link) continue;
            var domain = link.getAttribute('title') || link.textContent.trim();
            if (domain && domain.indexOf('.') !== -1) {
                var item = { domain: domain, row: row, cell: cell };
                domains.push(item);
                domainMap[domain] = item;
            }
        }

        if (domains.length === 0) {
            bar.textContent = 'ERRORE: Nessun dominio trovato!';
            window.edcRunning = false;
            setTimeout(function() { bar.remove(); }, 3000);
            return;
        }

        bar.textContent = 'Trovati ' + domains.length + ' domini. Elaboro...';

        // Aggiungi header
        var hdrRow = table.querySelector('thead tr');
        if (hdrRow) {
            var oldHdrs = hdrRow.querySelectorAll('.edc-hdr');
            for (var h = 0; h < oldHdrs.length; h++) oldHdrs[h].remove();

            var domHdr = hdrRow.querySelector('th.head_domain');
            if (domHdr) {
                if (CONFIG.etvEnabled) {
                    var th1 = document.createElement('th');
                    th1.className = 'edc-hdr';
                    th1.textContent = 'ETV';
                    domHdr.after(th1);
                }
                if (CONFIG.gmbEnabled) {
                    var th2 = document.createElement('th');
                    th2.className = 'edc-hdr';
                    th2.textContent = 'GMB';
                    var afterEl = hdrRow.querySelector('.edc-hdr') || domHdr;
                    afterEl.after(th2);
                }
            }
        }

        // Aggiungi celle
        for (var j = 0; j < domains.length; j++) {
            var d = domains[j];
            var oldCells = d.row.querySelectorAll('.edc-cell');
            for (var c = 0; c < oldCells.length; c++) oldCells[c].remove();

            if (CONFIG.etvEnabled) {
                var td1 = document.createElement('td');
                td1.className = 'edc-cell edc-etv';
                td1.innerHTML = '<span class="edc-load">...</span>';
                d.cell.after(td1);
            }
            if (CONFIG.gmbEnabled) {
                var td2 = document.createElement('td');
                td2.className = 'edc-cell edc-gmb';
                td2.innerHTML = '<span class="edc-load">...</span>';
                var afterCell = d.row.querySelector('.edc-etv') || d.cell;
                afterCell.after(td2);
            }
        }

        // Helper
        function formatETV(v) {
            if (!v) return '0';
            if (v >= 1000000) return (v / 1000000).toFixed(1) + 'M';
            if (v >= 1000) return (v / 1000).toFixed(1) + 'K';
            return String(v);
        }

        function updateETV(domain, data) {
            var item = domainMap[domain];
            if (!item) return;
            var cell = item.row.querySelector('.edc-etv');
            if (!cell) return;

            if (data && data.etv !== undefined) {
                var v = data.etv;
                var cls = v >= 10000 ? 'edc-hi' : (v >= 1000 ? 'edc-md' : 'edc-lo');
                cell.innerHTML = '<span class="' + cls + '" title="' + v + '">' + formatETV(v) + '</span>';
            } else {
                cell.innerHTML = '<span class="edc-lo">0</span>';
            }
        }

        function updateGMB(domain, data) {
            var item = domainMap[domain];
            if (!item) return;
            var cell = item.row.querySelector('.edc-gmb');
            if (!cell) return;

            if (data && data.hasGMB === true) {
                cell.innerHTML = '<span class="edc-yes">SI</span>';
            } else if (data && data.hasGMB === false) {
                cell.innerHTML = '<span class="edc-no">NO</span>';
            } else {
                cell.innerHTML = '<span class="edc-lo">?</span>';
            }
        }

        var etvDone = !CONFIG.etvEnabled;
        var gmbDone = !CONFIG.gmbEnabled;
        var gmbProgress = 0;

        function updateProgress() {
            var parts = [];
            if (CONFIG.etvEnabled) parts.push('ETV: ' + (etvDone ? 'OK' : '...'));
            if (CONFIG.gmbEnabled) parts.push('GMB: ' + gmbProgress + '/' + domains.length);
            bar.textContent = parts.join(' | ');

            if (etvDone && gmbDone) {
                bar.textContent = 'Completato! ' + domains.length + ' domini.';
                window.edcRunning = false;
                setTimeout(function() { bar.remove(); }, 5000);
            }
        }

        // ETV: Una singola richiesta bulk per TUTTI i domini
        if (CONFIG.etvEnabled) {
            var allDomains = domains.map(function(x) { return x.domain; });

            chrome.runtime.sendMessage({
                action: 'fetchETV',
                serverUrl: CONFIG.serverUrl,
                domains: allDomains,
                location: CONFIG.etvLocation,
                language: CONFIG.etvLanguage
            }, function(results) {
                results = results || {};
                for (var dom in results) {
                    updateETV(dom, results[dom]);
                }
                // Aggiorna anche quelli senza risultato
                for (var k = 0; k < domains.length; k++) {
                    if (!results[domains[k].domain]) {
                        updateETV(domains[k].domain, null);
                    }
                }
                etvDone = true;
                updateProgress();
            });
        }

        // GMB: TUTTI i domini in una singola richiesta - server li processa in parallelo
        if (CONFIG.gmbEnabled) {
            var allGmbDomains = domains.map(function(x) { return x.domain; });

            chrome.runtime.sendMessage({
                action: 'fetchGMB',
                serverUrl: CONFIG.serverUrl,
                domains: allGmbDomains,
                geo: CONFIG.gmbGeo
            }, function(results) {
                results = results || {};
                for (var i = 0; i < allGmbDomains.length; i++) {
                    var dom = allGmbDomains[i];
                    updateGMB(dom, results[dom.toLowerCase()]);
                    gmbProgress++;
                    updateProgress();
                }
                gmbDone = true;
                updateProgress();
            });
        }

        updateProgress();
    }
})();
