const DEFAULTS = {
    serverUrl: 'http://72.61.85.207:3847',
    etvEnabled: true,
    etvLocation: '',
    etvLanguage: '',
    gmbEnabled: true,
    gmbGeo: 'it'
};

function loadSettings() {
    chrome.storage.sync.get(DEFAULTS, (cfg) => {
        document.getElementById('serverUrl').value = cfg.serverUrl;
        document.getElementById('etvEnabled').checked = cfg.etvEnabled;
        document.getElementById('etvLocation').value = cfg.etvLocation;
        document.getElementById('etvLanguage').value = cfg.etvLanguage;
        document.getElementById('gmbEnabled').checked = cfg.gmbEnabled;
        document.getElementById('gmbGeo').value = cfg.gmbGeo;
    });
}

function getConfig() {
    return {
        serverUrl: document.getElementById('serverUrl').value.trim() || DEFAULTS.serverUrl,
        etvEnabled: document.getElementById('etvEnabled').checked,
        etvLocation: document.getElementById('etvLocation').value,
        etvLanguage: document.getElementById('etvLanguage').value,
        gmbEnabled: document.getElementById('gmbEnabled').checked,
        gmbGeo: document.getElementById('gmbGeo').value
    };
}

function showStatus(msg, type) {
    const el = document.getElementById('status');
    el.textContent = msg;
    el.className = 'show ' + type;
    setTimeout(() => { el.className = ''; }, 4000);
}

async function saveSettings() {
    await chrome.storage.sync.set(getConfig());
    showStatus('Salvato!', 'ok');
}

async function startCalcola() {
    const btn = document.getElementById('btn-calcola');
    btn.disabled = true;
    btn.textContent = 'Avvio...';

    // Salva config prima di iniettare
    const cfg = getConfig();
    await chrome.storage.sync.set(cfg);

    try {
        const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });

        if (!tab || !tab.url || !tab.url.includes('expireddomains.net')) {
            showStatus('Apri expireddomains.net prima!', 'err');
            btn.disabled = false;
            btn.textContent = 'CALCOLA ETV + GMB';
            return;
        }

        // Inietta content.js che usa background.js per le chiamate HTTP
        await chrome.scripting.executeScript({
            target: { tabId: tab.id },
            files: ['content.js']
        });

        showStatus('Calcolo avviato! Guarda la pagina.', 'ok');

    } catch (err) {
        showStatus('Errore: ' + err.message, 'err');
        console.error(err);
    }

    btn.disabled = false;
    btn.textContent = 'CALCOLA ETV + GMB';
}

document.addEventListener('DOMContentLoaded', function() {
    loadSettings();
    document.getElementById('btn-calcola').addEventListener('click', startCalcola);
    document.getElementById('btn-save').addEventListener('click', saveSettings);
});
