// Background service worker - gestisce le chiamate API
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'fetchETV') {
        fetchETV(request.serverUrl, request.domains, request.location)
            .then(sendResponse);
        return true;
    }
    if (request.action === 'fetchGMB') {
        fetchGMB(request.serverUrl, request.domains, request.geo, request.provider, request.useMaps)
            .then(sendResponse);
        return true;
    }
});

async function fetchETV(serverUrl, domains, location) {
    try {
        const body = { domains };
        if (location) body.location_code = parseInt(location);

        const response = await fetch(serverUrl + '/api/etv', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(body)
        });

        const data = await response.json();

        if (!data.success) {
            return {
                error: true,
                errorType: data.errorType || 'ETV_ERROR',
                errorMessage: data.error || 'Errore sconosciuto ETV'
            };
        }

        return data.results || {};

    } catch (e) {
        console.error('ETV error:', e);
        return {
            error: true,
            errorType: 'NETWORK_ERROR',
            errorMessage: 'Impossibile contattare il server: ' + e.message
        };
    }
}

async function fetchGMB(serverUrl, domains, geo, provider = 'serper', useMaps = false) {
    try {
        // Choose endpoint based on provider
        const endpoint = provider === 'dataforseo' ? '/api/gmb-dataforseo' : '/api/gmb-serper';

        const response = await fetch(serverUrl + endpoint, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ domains, geo, useMaps })
        });

        const data = await response.json();

        if (!data.success) {
            return {
                error: true,
                errorType: data.errorType || 'GMB_ERROR',
                errorMessage: data.error || 'Errore sconosciuto GMB'
            };
        }

        // Add stats for reporting
        return {
            results: data.results || {},
            stats: data.stats || {}
        };

    } catch (e) {
        console.error('GMB error:', e);
        return {
            error: true,
            errorType: 'NETWORK_ERROR',
            errorMessage: 'Impossibile contattare il server: ' + e.message
        };
    }
}
